# -*- coding: utf-8 -*-
import json
import logging
import os


log = logging.getLogger(__name__)


MONITORING_STATUS_OK = 0
MONITORING_STATUS_WARN = 1
MONITORING_STATUS_CRIT = 2


class MonitoringState(object):
    def __init__(self, service):
        self.path = os.path.join('/tmp', '%s_monitoring_state' % service)
        self.data = {}

    def __getitem__(self, item):
        return self.data.get(item)

    def __setitem__(self, key, value):
        self.data[key] = value

    def __enter__(self):
        # lock
        self.data = {}
        try:
            if os.path.exists(self.path):
                with open(self.path, 'rb') as f:
                    self.data = json.load(f)
        except:
            pass
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        with open(self.path, 'wb') as f:
            json.dump(self.data, f)
        # unlock
