# -*- coding: utf-8 -*-
import logging
import signal


log = logging.getLogger('runner.emitters.base')


class Emitter(object):
    def __init__(self):
        self.ack_queue = None
        self.tasks_queue = None
        self.tasks_storage = None
        self.process = None

    def handle_sigint(self, signum, frame):
        pass

    def run(self, ack_queue, tasks_queue, tasks_storage):
        signal.signal(signal.SIGINT, self.handle_sigint)

        self.ack_queue = ack_queue
        self.tasks_queue = tasks_queue
        self.tasks_storage = tasks_storage
        try:
            self.loop()
        except Exception:
            log.exception('Unhandled exception in emitter')
            raise

    def loop(self):
        raise NotImplementedError()
