# -*- coding: utf-8 -*-

from multiprocessing import Queue

from passport.backend.logbroker_client.core.runner.queues.base import BaseQueue
from passport.backend.logbroker_client.core.runner.queues.exceptions import (
    EmptyQueueException,
    FullQueueException,
)
from six.moves.queue import (
    Empty,
    Full,
)


class MPQueue(BaseQueue):
    def __init__(self, maxsize=None):
        self._queue = Queue(maxsize=maxsize)

    def __put(self, obj, block=True, timeout=None):
        try:
            return self._queue.put(obj, block, timeout)
        except Full:
            raise FullQueueException()

    def put(self, obj):
        return self.__put(obj)

    def put_timeout(self, obj, timeout):
        return self.__put(obj, timeout=timeout)

    def put_nowait(self, obj):
        return self.__put(obj, block=False)

    def __get(self, block=True, timeout=None):
        try:
            return self._queue.get(block, timeout)
        except Empty:
            raise EmptyQueueException()

    def get(self):
        return self.__get()

    def get_timeout(self, timeout):
        return self.__get(timeout=timeout)

    def get_nowait(self):
        return self.__get(block=False)
