# -*- coding: utf-8 -*-

from passport.backend.logbroker_client.core.runner.storages.base import BaseTaskStorage


class MemoryTaskStorage(BaseTaskStorage):
    def __init__(self):
        self._storage = {}

    def save(self, task):
        self._storage[task.id_] = task

    def delete(self, id_):
        if id_ in self._storage:
            del self._storage[id_]
            return True
        return False

    def get(self, id_):
        return self._storage.get(id_)

    def old_tasks(self, bound):
        missing_tasks = []
        for task in self._storage.values():
            if task.time < bound:
                missing_tasks.append(task)
        return missing_tasks
