# -*- coding: utf-8 -*-
import logging
import signal


log = logging.getLogger('runner.workers.basic')


class Worker(object):
    def __init__(self):
        self.ack_queue = None
        self.tasks_queue = None

    def handle_sigint(self, signum, frame):
        pass

    def run(self, ack_queue, tasks_queue):
        signal.signal(signal.SIGINT, self.handle_sigint)

        self.ack_queue = ack_queue
        self.tasks_queue = tasks_queue
        try:
            self.loop()
        except Exception:
            log.exception('Unhandled exception in worker')
            raise

    def loop(self):
        raise NotImplementedError()
