PY23_LIBRARY()

OWNER(
    g:passport_python
)

PEERDIR(
    contrib/python/six
    contrib/python/kazoo
    library/python/yenv

    library/python/tskv
    library/python/ylog

    passport/backend/core/ydb_client
    kikimr/public/sdk/python/persqueue

    passport/backend/library/commander
    passport/backend/library/configurator
    passport/backend/library/historydbloader/historydb
    passport/backend/library/log

    passport/backend/core/builders/xunistater
    passport/backend/core/exceptions
    passport/backend/core/logbroker
    passport/backend/core/logging_utils
    passport/backend/core/protobuf/logbroker_passport_protocol
    passport/backend/core/types/account
    passport/backend/core/utils
)

PY_SRCS(
    __init__.py
    consumers/__init__.py
    consumers/distributed/__init__.py
    consumers/distributed/emitter.py
    consumers/distributed/worker.py
    consumers/exceptions.py
    consumers/simple/__init__.py
    consumers/simple/emitter.py
    consumers/simple/native_emitter.py
    consumers/simple/native_worker.py
    consumers/simple/worker.py
    events/__init__.py
    events/events.py
    events/filters.py
    handlers/__init__.py
    handlers/base.py
    handlers/clients/notify.py
    handlers/exceptions.py
    handlers/protobuf.py
    handlers/utils.py
    logbroker/__init__.py
    logbroker/client.py
    logbroker/decompress.py
    logbroker/native_client.py
    logbroker/tskv.py
    monitoring.py
    run.py
    runner/__init__.py
    runner/arbiter.py
    runner/emitters/__init__.py
    runner/emitters/base.py
    runner/emitters/basic.py
    runner/exceptions.py
    runner/queues/__init__.py
    runner/queues/base.py
    runner/queues/exceptions.py
    runner/queues/mpqueue.py
    runner/storages/__init__.py
    runner/storages/base.py
    runner/storages/memory.py
    runner/tasks/__init__.py
    runner/tasks/base.py
    runner/tasks/files.py
    runner/workers/__init__.py
    runner/workers/base.py
    runner/workers/basic.py
    runner/workers/exceptions.py
    scripts/push-client-checker.py
    tests/test_events/__init__.py
    tests/test_events/base.py
    tests/test_events/test_events.py
    tests/test_events/test_filter.py
    tests/test_worker.py
    utils.py
)

IF (PYTHON2)
    PY_SRCS(
        logbroker/hhttplib.py
    )
ENDIF()

RESOURCE(
    configs/base.yaml /etc/yandex/logbroker-client/base.yaml
    configs/export.yaml /etc/yandex/logbroker-client/export.yaml
    configs/logging.yaml /etc/yandex/logbroker-client/logging.yaml
    configs/logging_native.yaml /etc/yandex/logbroker-client/logging_native.yaml
    configs/logging_prefix.yaml /etc/yandex/logbroker-client/logging_prefix.yaml
)

END()

RECURSE(
    native_runner
)

RECURSE_FOR_TESTS(
    test
    tests
)
