from threading import RLock

from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.core.tvm import TvmCredentialsManager


@lazy_loadable()
class TvmCredentialsManagerSynchronized(TvmCredentialsManager):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.main_lock = RLock()

    def get_ticket_by_alias(self, alias):
        with self.main_lock:
            return super().get_ticket_by_alias(alias)

    def get_user_context(self):
        with self.main_lock:
            return super().get_user_context()

    def get_ticket_by_client_id(self, client_id):
        with self.main_lock:
            return super().get_ticket_by_client_id(client_id)


def get_tvm_credentials_manager_synchronized():
    manager = LazyLoader.get_instance('TvmCredentialsManagerSynchronized')
    manager.load()
    return manager
