PY3_LIBRARY()

OWNER(
    g:passport_python
)

PEERDIR(
    passport/backend/core/builders/blackbox
    passport/backend/core/builders/sender_api
    passport/backend/core/conf
    passport/backend/core/exceptions
    passport/backend/core/lazy_loader
    passport/backend/core/mail_subscriptions
    passport/backend/core/models
    passport/backend/core/tvm
    passport/backend/core/types/email
    passport/backend/core/utils/decorators
    passport/backend/core/undefined
    passport/backend/logbroker_client/core
    passport/backend/utils
)

PY_SRCS(
    __init__.py
    events.py
    handler.py
    tools.py
)

RESOURCE(
    configs/base.yaml /etc/yandex/logbroker-client/mail_unsubscriptions/base.yaml
    configs/development.yaml /etc/yandex/logbroker-client/mail_unsubscriptions/development.yaml
    configs/export.yaml /etc/yandex/logbroker-client/mail_unsubscriptions/export.yaml
    configs/production.yaml /etc/yandex/logbroker-client/mail_unsubscriptions/production.yaml
    configs/testing.yaml /etc/yandex/logbroker-client/mail_unsubscriptions/testing.yaml
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
