# -*- coding: utf-8 -*-
import logging

from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.library.historydbloader.historydb.utils import parse_comment
from passport.backend.logbroker_client.core.events.events import UserEvent


log = logging.getLogger(__name__)


class TokenRefreshEvent(UserEvent):
    # событие подновления токена
    NAME = 'oauthcheck_and_refresh'
    PARSER_TYPE = ParserType.AUTH

    REFRESH_FLAG_FIELD = 'rf'
    TOKEN_ID_FIELD = 'tokid'

    STATUS_SUCCESSFUL = 'successful'
    TYPE_OAUTHCHECK = 'oauthcheck'

    @staticmethod
    def is_this_event(parser_type, event):
        if (parser_type == TokenRefreshEvent.PARSER_TYPE and
                event.get('status') == TokenRefreshEvent.STATUS_SUCCESSFUL and
                event.get('type') == TokenRefreshEvent.TYPE_OAUTHCHECK):
            comment = event.get('comment', '')  # example ssl=1;aid=1409658335000:ea6MJQ:84;ttl=5
            parsed_comment = parse_comment(comment)
            refresh_token = parsed_comment.get(TokenRefreshEvent.REFRESH_FLAG_FIELD)
            if refresh_token != '1':
                return
            token_id = parsed_comment.get(TokenRefreshEvent.TOKEN_ID_FIELD)
            if not token_id:
                return
            return TokenRefreshEvent(event['uid'], event['timestamp'], token_id)
        else:
            return

    def __init__(self, uid, timestamp, token_id):
        super(TokenRefreshEvent, self).__init__(self.NAME, uid, timestamp)
        self.token_id = token_id
