# -*- coding: utf-8 -*-
import logging

from passport.backend.logbroker_client.core.events.filters import BasicFilter
from passport.backend.logbroker_client.core.handlers.base import BaseHandler
from passport.backend.logbroker_client.core.handlers.exceptions import HandlerException
from passport.backend.logbroker_client.core.handlers.utils import MessageChunk
from passport.backend.logbroker_client.core.utils import is_yateam_uid
from passport.backend.logbroker_client.oauth.events import TokenRefreshEvent
from passport.backend.logbroker_client.oauth.exceptions import BaseOAuthError
from passport.backend.logbroker_client.oauth.oauth import OAuth


log = logging.getLogger(__name__)


class OAuthHandlerException(HandlerException):
    pass


class OAuthHandler(BaseHandler):
    handler_name = 'oauth'

    OAUTH_TIMEOUT = 3

    def __init__(self, config, host, oauth=None, **kwargs):
        super(OAuthHandler, self).__init__(config=config, **kwargs)
        events_classes = [TokenRefreshEvent]
        self.filter = BasicFilter(events_classes)
        self.oauth = oauth if oauth else OAuth(host, timeout=self.OAUTH_TIMEOUT)

    def parse_message(self, message):
        return self.filter.filter(message)

    def process(self, header, data):
        message = MessageChunk(header, data)
        events = self.get_message_entries(message)
        for event in events:
            self.process_event(event)
        return True

    def process_event(self, event):
        if is_yateam_uid(event.uid):
            return
        try:
            self.oauth.refresh_token(event.token_id)
            log.debug('Successfully notified OAuth. Uid=%s. token_id=%s', event.uid, event.token_id)
        except BaseOAuthError as e:
            raise OAuthHandlerException("Coundn't notify oauth. %s" % e)
