# -*- coding: utf-8 -*-
import logging

from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.logbroker_client.core.events.events import UserEvent


log = logging.getLogger(__name__)


class PassportNewDefaultAvatarEvent(UserEvent):
    # событие смены аватарки
    NAME = 'account.default_avatar_changed'

    PARSER_TYPE = ParserType.PASSPORT_STATBOX

    @classmethod
    def is_this_event(cls, parser_type, event):
        if (
            parser_type == cls.PARSER_TYPE and
            event.get('event') == 'account_modification' and
            event.get('entity') == 'person.default_avatar' and
            event.get('uid') is not None and
            event.get('new', '-') != '-'
        ):
            return cls(
                uid=event['uid'],
                timestamp=event.get('unixtime'),
                avatar_key=event['new'],
            )

    def __init__(self, uid, timestamp, avatar_key):
        super(PassportNewDefaultAvatarEvent, self).__init__(self.NAME, uid, timestamp)
        self.avatar_key = avatar_key


class PassportNewNameEvent(UserEvent):
    # базовое события для смен имён
    PARSER_TYPE = ParserType.PASSPORT_STATBOX

    @classmethod
    def is_this_event(cls, parser_type, event):
        if (
            parser_type == cls.PARSER_TYPE and
            event.get('event') == 'account_modification' and
            event.get('entity') == 'person.{}'.format(cls.NAME_TYPE) and
            event.get('uid') is not None and
            event.get('new', '-') != '-'
        ):
            return cls(
                uid=event['uid'],
                timestamp=event.get('unixtime'),
                value=event['new'],
            )

    def __init__(self, uid, timestamp, value):
        super(PassportNewNameEvent, self).__init__(self.NAME, uid, timestamp)
        self.value = value
        self.field = self.FIELD_NAME


class PassportNewFullnameEvent(PassportNewNameEvent):
    # событие смены полного имени
    NAME = 'account.fullname_changed'
    NAME_TYPE = 'fullname'
    FIELD_NAME = 'full_name'


class PassportNewDisplaynameEvent(PassportNewNameEvent):
    # событие смены display_name
    NAME = 'account.displayname_changed'
    NAME_TYPE = 'display_name'
    FIELD_NAME = 'display_name'
