# -*- coding: utf-8 -*-
import json
import logging

from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.logbroker_client.core.events.events import Event


log = logging.getLogger(__name__)


class TolokaEvent(Event):
    NAME = 'toloka_event'
    PARSER_TYPE = ParserType.PASSPORT_TOLOKA

    @classmethod
    def is_this_event(cls, parser_type, event):
        log.debug(event)
        if (
            'name' in event
            and 'entity' in event
            and 'value' in event
        ):
            return cls(
                resolution=event['name'],
                entity=event['entity'],
                value=event['value'],
                data=json.loads(event['data']) if 'data' in event else None,
            )

    def __init__(self, resolution, entity, value, data):
        super(TolokaEvent, self).__init__(self.NAME)
        self.resolution = resolution
        self.entity = entity
        self.value = value
        self.data = data
