# -*- coding: utf-8 -*-
import logging

from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.logbroker_client.core.events.events import UserEvent


log = logging.getLogger(__name__)


class RevokeOAuthTokensEvent(UserEvent):
    # событие асинхронного отзыва oauth-токенов
    NAME = 'revoke_oauth_tokens'

    PARSER_TYPE = ParserType.PASSPORT_STATBOX

    @classmethod
    def is_this_event(cls, parser_type, event):
        if parser_type != cls.PARSER_TYPE:
            return
        if event.get('action') != 'revoke_drive_device':
            return
        if event.get('_is_external_event') == '1':
            return
        uid = event.get('uid')
        device_id = event.get('device_id')
        user_ip = event.get('ip')
        if uid is None or device_id is None or user_ip is None:
            return

        return cls(
            uid=uid,
            timestamp=event.get('unixtime'),
            device_id=device_id,
            user_ip=user_ip,
        )

    def __init__(self, uid, timestamp, device_id, user_ip):
        super(RevokeOAuthTokensEvent, self).__init__(self.NAME, uid, timestamp)
        self.uid = uid
        self.device_id = device_id
        self.user_ip = user_ip
