# -*- coding: utf-8 -*-
import json
import logging

from passport.backend.core.builders.taxi_zalogin import EVENT_TYPE
from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.logbroker_client.core.events.events import UserEvent


log = logging.getLogger(__name__)


class SocialBindingsEvent(UserEvent):
    # событие связки или отвязки портального профиля с социальным
    NAME = 'social_bindings'

    PARSER_TYPE = ParserType.SOCIAL_BINDINGS

    @classmethod
    def is_this_event(cls, parser_type, event):
        if parser_type != cls.PARSER_TYPE:
            return
        if event.get('action') == 'binding_created':
            # связка
            # master_uid=X provider_code=Y slave_userid=Z
            provider_code = event.get('provider_code')
            provider_uid = event.get('slave_userid')
            providers_uids = [(provider_code, provider_uid)]
            event_type = EVENT_TYPE.BIND
        elif event.get('action') == 'bindings_deleted':
            # отвязка
            # master_uid=X slave_provider_userids=[[X,Z]]
            event_type = EVENT_TYPE.UNBIND
            try:
                providers_uids = json.loads(event.get('slave_provider_userids'))
            except (TypeError, ValueError):
                return
        else:
            return
        uid = event.get('master_uid')
        if not uid and not providers_uids:
            return

        return cls(
            uid=uid,
            timestamp=event.get('unixtime'),
            event_type=event_type,
            providers_uids=providers_uids,
        )

    def __init__(self, uid, timestamp, event_type, providers_uids):
        super(SocialBindingsEvent, self).__init__(self.NAME, uid, timestamp)
        self.event_type = event_type
        self.providers_uids = providers_uids


class BindPhonishAccountByTrackEvent(UserEvent):
    NAME = 'bind_phonish_account_by_track'
    PARSER_TYPE = ParserType.SOCIAL_BINDINGS

    @classmethod
    def is_this_event(cls, parser_type, event):
        if event.get('action') == cls.NAME:
            return cls(
                ip=event.get('ip'),
                timestamp=event.get('unixtime'),
                track_id=event.get('track_id'),
                uid=event.get('uid'),
            )

    def __init__(
        self,
        ip,
        timestamp,
        track_id,
        uid,
    ):
        self.ip = ip
        self.timestamp = int(float(timestamp))
        self.track_id = track_id
        self.uid = uid
