PY3_LIBRARY()

OWNER(
    g:passport_python
)

PEERDIR(
    passport/backend/core/builders/takeout
    passport/backend/core/builders/passport
    passport/backend/core/utils/decorators
    passport/backend/core/logbroker/faker
    passport/backend/core/protobuf/takeout
    passport/backend/logbroker_client/core
    passport/backend/logbroker_client/core/native_runner
    passport/backend/takeout/common
    passport/backend/takeout/logbroker_client
)

PY_SRCS(
    __init__.py
    exceptions.py
    handler.py
)

RESOURCE(
    configs/secrets.yaml /etc/yandex/logbroker-client/takeout/secrets.yaml
    configs/base.yaml /etc/yandex/logbroker-client/takeout-tasks/base.yaml
    configs/development.yaml /etc/yandex/logbroker-client/takeout-tasks/development.yaml
    configs/testing.yaml /etc/yandex/logbroker-client/takeout-tasks/testing.yaml
    configs/production.yaml /etc/yandex/logbroker-client/takeout-tasks/production.yaml
    configs/logging.yaml /etc/yandex/logbroker-client/takeout-tasks/logging.yaml
    configs/export.yaml /etc/yandex/logbroker-client/takeout-tasks/export.yaml
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
