from passport.backend.library.commander import Commander
from passport.backend.library.configurator import Configurator
from passport.backend.luigid import run_luigid
import yenv


def get_config():
    return Configurator(
        'passport-luigid',
        configs=[{'yenv': {'type': yenv.type}}, 'base.yaml', '%s.yaml' % yenv.type, 'logging.yaml'],
    )


def main():
    config = get_config()
    config.set_logging(make_path=True)

    commander = Commander(
        processor=run_luigid,
        config=config,
    ).add_argument(
        '-p', '--port',
        dest='api_port',
        default=8082,
    ).add_argument(
        '-a', '--address',
        dest='address',
    )
    commander.invoke()
