#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import os

from passport.backend.mobileproxy_nginx.pins import settings


def dump(dest_dir):
    print('Dumping pins to files ...')

    content = {
        'blacklist': settings.BLACKLISTED_CERT_PINS,
        'pins-sha256': settings.TRUSTED_CERT_PINS,
    }
    for filename in ('pins.json', 'desktop_pins.json'):
        # Возможно, в будущем захотим для десктопов и мобилок
        # отдавать разные наборы пинов. Но не сейчас.
        with open(os.path.join(dest_dir, filename), 'w') as f:
            f.write(json.dumps(content, indent=2))

    print('Pins successfully dumped.')
