# -*- coding: utf-8 -*-
from django.http import HttpResponse
from django.utils.deprecation import MiddlewareMixin
from passport.backend.core.builders.blackbox.blackbox import BaseBlackboxError
from passport.backend.core.builders.passport import PassportTemporaryError
from passport.backend.oauth.core.common.error_logs import log_error
from passport.backend.oauth.core.db.eav import BaseDBError


TEMPORARILY_UNAVAILABLE_STUB = 'Service temporarily unavailable'
INTERNAL_ERROR_STUB = 'Internal server error'


class ErrorsMiddleware(MiddlewareMixin):
    def process_exception(self, request, exception):
        if issubclass(
            exception.__class__,
            (BaseBlackboxError, BaseDBError, PassportTemporaryError),
        ):
            return HttpResponse(TEMPORARILY_UNAVAILABLE_STUB, status=503)
        else:
            log_error(request)
            return HttpResponse(INTERNAL_ERROR_STUB, status=500)
