# -*- coding: utf-8 -*-
import collections.abc
from urllib.parse import (
    parse_qs,
    urlencode,
    urlparse,
    urlunparse,
)

from django import template


register = template.Library()


@register.simple_tag
def url_set_arg(url, param, value):
    scheme, netloc, path, params, query, fragment = urlparse(url)
    p = parse_qs(query)
    p.update({param: value})
    parameters = []
    for k, vlist in p.items():
        if not isinstance(vlist, collections.abc.Iterable) or isinstance(vlist, str):
            vlist = [vlist]
        for v in vlist:
            if not v:
                continue
            parameters.append((k, v))
    query = urlencode(parameters)
    return urlunparse((scheme, netloc, path, params, query, fragment))
