# -*- coding: utf-8 -*-
from django.urls import (
    include,
    path,
)
from passport.backend.oauth.admin.admin import views


urlpatterns = [
    path('<env_name>/', include([
        path('clients', views.view_clients, name='view_clients'),
        path('clients', views.view_clients, name='view_clients'),
        path('client/<client_id>/edit', views.edit_client, name='edit_client'),
        path('users', views.view_users, name='view_users'),
        path('user/<int:uid>/edit', views.edit_user, name='edit_user'),
        path('user/<int:uid>/tokens', views.view_tokens, name='view_tokens'),
        path('token/verify', views.verify_token, name='verify_token'),
        path('am_creds', views.encrypt_am_creds, name='encrypt_am_creds'),
        path('scope/new', views.new_scope, name='new_scope'),
        path('', views.index, name='index'),
        path('ping', views.ping, name='ping'),
    ])),
]
