# -*- coding: utf-8 -*-
# isort:skip_file
# Django settings for yandex-oauth project.


DEBUG = False

REQUIRE_HTTPS = True
CSRF_COOKIE_SECURE = True

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = False

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = '/var/lib/yandex/oauth-admin/media/'
STATIC_ROOT = MEDIA_ROOT

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = '/media/'
STATIC_URL = MEDIA_URL

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'b^o4*n(%_df&0dnte-xo)qsc+k4*i=@ll=q0g-$(ad)crqxggz'

MIDDLEWARE = (
    'passport.backend.oauth.admin.admin.middlewares.ErrorsMiddleware',
    'passport.backend.oauth.core.api.middlewares.HTTPSMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'passport.backend.oauth.core.api.middlewares.RequestDataMiddleware',
)

ROOT_URLCONF = 'passport.backend.oauth.admin.admin.urls'


TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': DEBUG,
            'context_processors': (
                # default
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.template.context_processors.request',
                # custom
                'django_yauth.context.yauth',
                'passport.backend.oauth.admin.admin.context_processors.request_full_path',
                'passport.backend.oauth.admin.admin.context_processors.env_name',
            ),
            'loaders': (
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ),
        },
    },
]

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

INSTALLED_APPS = (
    'passport.backend.oauth.admin.admin',
    'django_yauth',
)

ALLOWED_HOSTS = ['*']
