# -*- coding: utf-8 -*-
from passport.backend.oauth.core.api.errors import BaseApiError


class ClientSecretNotMatchedError(BaseApiError):
    """Передан неверный client_secret"""
    errors = ['client_secret.not_matched']


class CodeNotFoundError(BaseApiError):
    """Код подтверждения протух или никогда не существовал"""
    errors = ['code.not_found']


class CodeNotAcceptedError(BaseApiError):
    """Код подтверждения ещё не подтверждён пользователем"""
    errors = ['code.not_accepted']


class CodeOwnerRequiredError(BaseApiError):
    """Операция может выполняться только владельцем кода подтверждения"""
    errors = ['code.owner_required']


class ActionNotRequiredError(BaseApiError):
    """Данная операция не возымеет эффекта - всё уже сделано до нас"""
    errors = ['action.not_required']


class TokenInvalidTypeError(BaseApiError):
    """Токен такого вида не подходит для данной операции"""
    errors = ['token.invalid_type']


class ScopeNotAllowedError(BaseApiError):
    """Этот скоуп нельзя использовать в данной операции"""
    errors = ['scope.not_allowed']


class IconNotFoundError(BaseApiError):
    """Не удалось скачать иконку"""
    errors = ['icon.not_found']


class IconBadFormatError(BaseApiError):
    """Загружаемая иконка имеет неподдерживаемый формат"""
    errors = ['icon.bad_format']


class DomainInvalidError(BaseApiError):
    """Невалидный домен"""
    errors = ['domain.invalid']


class ClientIdNotAllowedError(BaseApiError):
    """Нельзя редактировать данный ClientId"""
    errors = ['client_id.not_allowed']


__all__ = (
    'ActionNotRequiredError',
    'ClientIdNotAllowedError',
    'ClientSecretNotMatchedError',
    'CodeNotAcceptedError',
    'CodeNotFoundError',
    'CodeOwnerRequiredError',
    'DomainInvalidError',
    'IconBadFormatError',
    'IconNotFoundError',
    'ScopeNotAllowedError',
    'TokenInvalidTypeError',
)
