# -*- coding: utf-8 -*-
from django.urls import path
from passport.backend.oauth.api.api.external import views


urlpatterns = [
    path('1/tokens/revoke', views.RevokeTokens.as_view(), name='api_revoke_tokens'),
    path('1/token/revoke', views.RevokeTokenById.as_view(), name='api_revoke_token_by_id'),
    path('1/token/revoke/by_access_token', views.RevokeTokenByAccessToken.as_view(), name='api_revoke_token_by_access_token'),
    path('1/token/refresh', views.RefreshToken.as_view(), name='api_refresh_token'),
    path('1/authorization_code/issue', views.IssueAuthorizationCode.as_view(), name='api_issue_authorization_code'),
    path('1/authorization_code/activate', views.ActivateAuthorizationCode.as_view(), name='api_activate_authorization_code'),
    path('1/device_code/issue', views.IssueDeviceCode.as_view(), name='api_issue_device_code'),
    path('1/device_code/check', views.CheckDeviceCode.as_view(), name='api_check_device_code'),
    path('1/device/status', views.DeviceStatus.as_view(), name='api_device_status'),
    path('1/device/revoke', views.RevokeDevice.as_view(), name='api_revoke_device'),
    path('1/takeout/user_info', views.TakeoutUserInfo.as_view(), name='api_takeout_user_info'),
    path('1/user_info/anonymized', views.AnonymizedUserInfo.as_view(), name='api_anonymized_user_info'),
    path('1/client/create/turboapp', views.CreateClientForTurboapp.as_view(), name='api_create_client_for_turboapp'),
    path('1/client/create/external', views.CreateClientExternal.as_view(), name='api_create_client_external'),
    path('1/client/edit/external', views.EditClientExternal.as_view(), name='api_edit_client_external'),
]
