# -*- coding: utf-8 -*-
from passport.backend.oauth.core.api.errors import BaseApiError


class TokenNotFoundError(BaseApiError):
    """Токен не найден"""
    errors = ['token.not_found']


class TokenOwnerRequiredError(BaseApiError):
    """Операция может выполняться только владельцем токена"""
    errors = ['token.owner_required']


class ClientCreatorRequiredError(BaseApiError):
    """Операция может выполняться только создателем приложения"""
    errors = ['client.creator_required']


class ClientBlockedError(BaseApiError):
    """Приложение заблокировано"""
    errors = ['client.blocked']


class ClientApprovalPendingError(BaseApiError):
    """Приложение ожидает модерации"""
    errors = ['client.approval_pending']


class ClientApprovalRejectedError(BaseApiError):
    """Приложение отклонено модератором"""
    errors = ['client.approval_rejected']


class ClientNotEditableError(BaseApiError):
    """Приложение не может быть изменено текущим пользователем или в текущем окружении"""
    errors = ['client.not_editable']


class ClientNotApplicableError(BaseApiError):
    """Приложение не подходит для использования в данной ручке"""
    errors = ['client.not_applicable']


class YandexClientDestructiveActionError(BaseApiError):
    """Данное действие может нарушить функционирование яндексового приложения"""
    errors = ['yandex_client.destructive_action']


class AccessDeniedError(BaseApiError):
    """Отсутствуют необходимые гранты"""
    errors = ['access.denied']


class TokenLimitExceededError(BaseApiError):
    """Превышен лимит числа токенов на пару (пользователь, приложение)"""
    errors = ['token.limit_exceeded']


class DescriptionMissingError(BaseApiError):
    """У приложения не заполнено описание"""
    errors = ['description.missing']


class AppIDNotMatchedError(BaseApiError):
    """Указанный app_id не совпадает с указанным при регистрации приложения"""
    errors = ['app_id.not_matched']


class FingerprintNotMatchedError(BaseApiError):
    """Указанный fingerprint не совпадает с указанным при регистрации приложения"""
    errors = ['fingerprint.not_matched']


class RedirectUriMissingError(BaseApiError):
    """Redirect URI не передан"""
    errors = ['redirect_uri.missing']


class RedirectUriNotMatchedError(BaseApiError):
    """Указанный Redirect URI не совпадает с указанным при регистрации приложения"""
    errors = ['redirect_uri.not_matched']


class RedirectUriNotRegisteredError(BaseApiError):
    """Приложение зарегистрировано без Redirect URI"""
    errors = ['redirect_uri.not_registered']


class RedirectUriInsecureError(BaseApiError):
    """Указанный Redirect URI небезопасен (http), токен на него отправлять нельзя"""
    errors = ['redirect_uri.insecure']


class RequestNotFoundError(BaseApiError):
    """Реквест с заданным id не найден или уже протух"""
    errors = ['request.not_found']


class PasswordRequiredError(BaseApiError):
    """Требуется ввод пароля пользователем"""
    errors = ['password.required']


class AccountIsChildError(BaseApiError):
    """Это детский аккаунт, ему нельзя получать токены для сторонних приложений"""
    errors = ['account.is_child']


class BadIconFormatError(BaseApiError):
    """Загружаемая иконка имеет неподдерживаемый формат"""
    errors = ['icon.bad_format']


class RequestedScopesMissingError(BaseApiError):
    """Набор скоупов не передан"""
    errors = ['requested_scopes.missing']


class RequestedScopesTooManyError(BaseApiError):
    """Передано слишком много скоупов"""
    errors = ['requested_scopes.too_many']


class RequestedScopesInvalidError(BaseApiError):
    """Передан невалидный набор скоупов"""
    errors = ['requested_scopes.invalid']


class ScopesNotMatchedError(BaseApiError):
    """Набор скоупов не соответствует приложению или первоначальному запросу"""
    errors = ['scopes.not_matched']


class PaymentAuthRequiredError(BaseApiError):
    """Для продолжения необходимо пройти платёжную авторизацию"""
    errors = ['payment_auth.required']


class PaymentAuthNotPassedError(BaseApiError):
    """Мы попросили пройти платёжную авторизацию, но этого не случилось"""
    errors = ['payment_auth.not_passed']


class PaymentAuthRetpathMissingError(BaseApiError):
    """Не передан retpath для возврата после прохождения платёжной авторизации"""
    errors = ['payment_auth_retpath.missing']


class PaymentAuthSchemeUnknownError(BaseApiError):
    """Такая scheme не поддерживается сервисом"""
    errors = ['payment_auth_scheme.unknown']
