# -*- coding: utf-8 -*-
from django.urls import path
from passport.backend.oauth.api.api.iface import views


urlpatterns = [
    path('1/clients/owned', views.ListOwnedClients.as_view(), name='iface_list_owned_clients'),
    path('1/global/settings', views.Settings.as_view(), name='iface_settings'),
    path('1/scopes/all', views.AllScopes.as_view(), name='iface_all_scopes'),
    path('3/authorize/submit', views.AuthorizeSubmit.as_view(), name='iface_authorize_submit'),
    path('2/authorize/get_state', views.AuthorizeGetState.as_view(), name='iface_authorize_get_state'),
    path('2/authorize/commit', views.AuthorizeCommit.as_view(), name='iface_authorize_commit'),
    path('1/device/authorize/submit', views.DeviceAuthorizeSubmit.as_view(), name='iface_device_authorize_submit'),
    path('1/device/authorize/commit', views.DeviceAuthorizeCommit.as_view(), name='iface_device_authorize_commit'),
    path('3/client/create', views.CreateClient.as_view(), name='iface_create_client'),
    path('3/client/edit', views.EditClient.as_view(), name='iface_edit_client'),
    path('3/client/validate', views.ValidateClientChanges.as_view(), name='iface_validate_client'),
    path('2/client/delete', views.DeleteClient.as_view(), name='iface_delete_client'),
    path('2/client/secret/new', views.NewClientSecret.as_view(), name='iface_new_client_secret'),
    path('2/client/secret/undo', views.UndoNewClientSecret.as_view(), name='iface_undo_new_client_secret'),
    path('1/client/glogout', views.GlogoutClient.as_view(), name='iface_glogout_client'),
    path('2/user/info', views.UserInfo.as_view(), name='iface_user_info'),
    path('3/client/info', views.ClientInfo.as_view(), name='iface_client_info'),
    path('1/clients/info', views.ClientsInfo.as_view(), name='iface_clients_info'),
    path('3/token/revoke', views.RevokeToken.as_view(), name='iface_revoke_token'),
    path('1/token/revoke_device', views.RevokeDeviceTokens.as_view(), name='iface_revoke_device_tokens'),
    path('1/token/list_groups', views.ListTokenGroups.as_view(), name='iface_list_token_groups'),
    path('3/tokens/list', views.ListTokens.as_view(), name='iface_list_tokens'),
    path('2/token/app_passwords/count', views.CountAppPasswords.as_view(), name='iface_app_passwords_count'),
    path('2/token/app_passwords/issue', views.IssueAppPassword.as_view(), name='iface_issue_app_password'),
]
