# -*- coding: utf-8 -*-
from functools import wraps

from django.http import HttpResponseForbidden
from passport.backend.oauth.core.db.limits import (
    check_grants,
    GrantsMissingError,
)


def requires_grant(grant, default_consumer=None):
    """
    Перед вызовом view проверяет наличие гранта, в случае отсутствия отдаёт 403 'No grants'.

    Примечание 1. Для старых ручек для совместимости задан default_consumer, который используется, если
      в запросе не был передан consumer.

    Примечание 2. Старые ручки не должны уметь работать по TVM.
    """
    def decorator(view_func):
        @wraps(view_func)
        def wrapper(request, *args, **kwargs):
            try:
                check_grants(
                    grants=[grant],
                    consumer=request.REQUEST.get('consumer', default_consumer),
                    ip=request.env.consumer_ip,
                    service_ticket=None,
                )
            except GrantsMissingError:
                return HttpResponseForbidden('No grants')
            return view_func(request, *args, **kwargs)
        return wrapper
    return decorator
