# -*- coding: utf-8 -*-
from django.urls import (
    path,
    re_path,
)
from passport.backend.oauth.api.api.old import (
    bundle_views,
    views,
)
from passport.backend.oauth.core.api.ping import ping


urlpatterns = [
    path('token', bundle_views.IssueTokenDispatcher.as_view(), name='token'),
    path('revoke_token', bundle_views.RevokeTokenView.as_view(), name='revoke_token'),
    path('device/code', bundle_views.IssueDeviceCodeView.as_view(), name='issue_device_code'),
    path('check_in', views.check_in, name='check_in'),
    re_path(r'^client/by_user/(?P<user_id>\d+)/?$', views.list_clients_by_user, name='list_clients_by_user'),
    re_path(r'^client/by_creator/(?P<creator_uid>\d+)/?$', views.list_clients_by_creator, name='list_clients_by_creator'),
    re_path(r'^client/(?P<client_id>\w+)/info/?$', views.client_info, name='client_info_api'),
    path('app_links/<client_id>/ios', views.ios_universal_links_associations, name='app_links_ios'),
    path('app_links/<client_id>/android', views.android_app_links_associations, name='app_links_android'),
    path('ping', ping, name='ping'),
]
