# -*- coding: utf-8 -*-
# isort:skip_file
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'passport.backend.oauth.api.settings.default_settings')

from django.core.wsgi import get_wsgi_application
from django.conf import settings
from passport.backend.core.turboapp_partners import get_ydb_turboapp_partners
from passport.backend.core.ydb.exceptions import YdbInstanceNotAvailable
from passport.backend.library.configurator import Configurator
from passport.backend.library.wsgi_runner import Runner
from passport.backend.oauth.core.api.startup import (
    configure_db_connections,
    prepare_environment,
)
import psutil
import yenv


def prepare_ydb_connections():
    # Так же, как и configure_db_connections, должна вызываться после форка
    try:
        get_ydb_turboapp_partners()
    except YdbInstanceNotAvailable:
        pass


def post_worker_init(_worker):
    configure_db_connections()
    prepare_ydb_connections()


def main():
    prepare_environment(skip_db=True)  # БД проинициализируем после форка
    application = get_wsgi_application()
    config = Configurator(
        'oauth/api',
        configs=[
            'base.yaml',
            '%s.yaml' % yenv.type,
            'devserver.yaml' if settings.DEBUG else {},
            'gunicorn-custom.yaml?',  # отсутствует в ресурсах, но может читаться с диска
        ],
    )

    workers = config.get('application', {}).get('workers')
    workers_by_threads = config.get('application', {}).get('workers_by_threads')
    if workers_by_threads and not workers:
        n_cpu = psutil.cpu_count(logical=True)
        workers = workers_by_threads.get(n_cpu, workers_by_threads['default'])
        config['application']['workers'] = workers

    runner = Runner(
        application,
        config=config,
    )
    runner.run()
