# -*- coding: utf-8 -*-
# isort:skip_file
# Django settings for yandex-oauth project.
from imp import load_source

import builtins
import yenv


DEBUG = False

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru'


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = False

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = '/media/'
STATIC_URL = MEDIA_URL

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'b^o4*n(%_df&0dnte-xo)qsc+k4*i=@ll=q0g-$(ad)crqxggz'


MIDDLEWARE = (
    'django.middleware.common.CommonMiddleware',
    'passport.backend.oauth.api.api.middlewares.LocalePerDomainMiddleware',
    'passport.backend.oauth.api.api.middlewares.ErrorsMiddleware',
    'passport.backend.oauth.core.api.middlewares.HTTPSMiddleware',
    'passport.backend.oauth.core.api.middlewares.RequestDataMiddleware',
    'passport.backend.oauth.core.api.middlewares.StoreEnvironmentMiddleware',
    'passport.backend.oauth.core.api.middlewares.StoreRequestMiddleware',
    'passport.backend.oauth.core.api.middlewares.LoggingMiddleware',
)

ROOT_URLCONF = 'passport.backend.oauth.api.api.urls'

TEMPLATES = []

INSTALLED_APPS = (
    'passport.backend.oauth.api.api',
)

ALLOWED_HOSTS = ['*']


# Иногда "физический" yenv не совпадает с "логическим" : например, админка для production обитает в intranet production.
# Поэтому храним в ENV_NAME и ENV_TYPE информацию о "логическом" окружении.
builtins.ENV_NAME = yenv.name
builtins.ENV_TYPE = yenv.type


from passport.backend.oauth.settings.api_settings import *  # noqa

# Данный блок должен идти последним в этом файле,
# чтобы его настройки могли перегрузить любую настройку
CUSTOM_SETTINGS_FILENAME = '/usr/lib/yandex/oauth-api/overridden_settings.py'
try:
    load_source('custom_settings', CUSTOM_SETTINGS_FILENAME)
    from custom_settings import *  # noqa
except IOError:
    pass
