# -*- coding: utf-8 -*-
import logging

from passport.backend.library.commander import Commander
from passport.backend.oauth.configs.cli.create_links import configure_create_links_command
from passport.backend.oauth.configs.cli.update_translations import configure_update_translations_command
from passport.backend.oauth.configs.cli.validate import configure_validate_command


def main():
    logging.basicConfig(format='%(message)s', level=logging.INFO)

    commander = Commander()

    configure_create_links_command(commander)
    configure_update_translations_command(commander)
    configure_validate_command(commander)

    commander.invoke()
