# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.builders.avatars_mds_api import (
    AvatarsMdsApi,
    AvatarsMdsApiBadImageFormatError,
    AvatarsMdsApiPermanentError,
    AvatarsMdsApiTemporaryError,
    BaseAvatarsMdsApiError,
)


def get_avatars_mds_api(retries=None):
    return AvatarsMdsApi(namespace=settings.AVATARS_NAMESPACE, retries=retries)


__all__ = [
    'get_avatars_mds_api',
    'BaseAvatarsMdsApiError',
    'AvatarsMdsApiBadImageFormatError',
    'AvatarsMdsApiTemporaryError',
    'AvatarsMdsApiPermanentError',
]
