# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf import settings
from passport.backend.core.builders.blackbox import (
    Blackbox,
    get_attribute,
)
from passport.backend.oauth.core.logs.graphite import GraphiteLogger
from passport.backend.utils.time import unixtime_to_datetime


def get_blackbox(url=None, tvm_dst_alias='blackbox'):
    return Blackbox(
        blackbox=url or settings.BLACKBOX_URL,
        timeout=settings.BLACKBOX_TIMEOUT,
        retries=settings.BLACKBOX_RETRIES,
        graphite_logger=GraphiteLogger(service='blackbox'),
        use_tvm=True,
        tvm_dst_alias=tvm_dst_alias,
    )


REVOKER_ALL = 'all'
REVOKER_TOKENS = 'tokens'
REVOKER_APP_PASSWORDS = 'app_passwords'
REVOKER_WEB_SESSIONS = 'web_sessions'


def _revoker_to_attr(revoker):
    return {
        REVOKER_ALL: settings.BB_ATTR_GLOGOUT,
        REVOKER_TOKENS: settings.BB_ATTR_REVOKER_TOKENS,
        REVOKER_APP_PASSWORDS: settings.BB_ATTR_REVOKER_APP_PASSWORDS,
        REVOKER_WEB_SESSIONS: settings.BB_ATTR_REVOKER_WEB_SESSIONS,
    }[revoker]


def get_revoke_time_from_bb_response(bb_response, revoker_name):
    return max([
        unixtime_to_datetime(get_attribute(
            bb_response,
            _revoker_to_attr(revoker),
        ))
        for revoker in (REVOKER_ALL, revoker_name)
    ])
