# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.builders.blackbox import (
    BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON,
    BlackboxInvalidParamsError,
)
from passport.backend.oauth.core.common.blackbox import (
    get_attribute,
    get_blackbox,
)


def get_uid_by_login_or_uid(login_or_uid, ip='127.0.0.1', blackbox=None):
    try:
        uid = int(login_or_uid)
        if uid > 0:
            return uid
    except ValueError:
        pass

    try:
        blackbox = blackbox or get_blackbox()
        bb_response = blackbox.userinfo(
            login=login_or_uid,
            ip=ip,
            dbfields=[],
            attributes=[],
            need_display_name=False,
            find_by_phone_alias=BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON,
        )
        return bb_response.get('uid')
    except BlackboxInvalidParamsError:
        return


def get_login_or_uid_by_uid(uid, ip='127.0.0.1', blackbox=None):
    try:
        blackbox = blackbox or get_blackbox()
        bb_response = blackbox.userinfo(
            uid=uid,
            ip=ip,
            dbfields=settings.BLACKBOX_DBFIELDS,
            attributes=settings.BLACKBOX_ATTRIBUTES,
            need_display_name=False,
        )
        return get_attribute(bb_response, 'account.normalized_login') or uid
    except BlackboxInvalidParamsError:
        return uid


def try_convert_uids_to_logins(uids, ip='127.0.0.1', blackbox=None):
    if not uids:
        return {}
    try:
        blackbox = blackbox or get_blackbox()
        bb_response = blackbox.userinfo(
            uids=uids,
            ip=ip,
            dbfields=settings.BLACKBOX_DBFIELDS,
            attributes=settings.BLACKBOX_ATTRIBUTES,
            need_display_name=False,
        )
        if isinstance(bb_response, dict):
            bb_response = [bb_response]
        return {
            int(user_info['id']): str(
                get_attribute(user_info, 'account.normalized_login') or
                user_info['uid'] or
                user_info['id']
            )
            for user_info in bb_response
        }
    except BlackboxInvalidParamsError:
        return {uid: str(uid) for uid in uids}
