# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf import settings
from passport.backend.core.builders.captcha import Captcha
from passport.backend.oauth.core.logs.graphite import GraphiteLogger


def generate(scale_factor=None, request_id=None):
    result = get_captcha().generate(
        image_type=settings.CAPTCHA_TYPE,
        checks=settings.CAPTCHA_CHECKS,
        https=True,
        scale_factor=scale_factor,
        request_id=request_id,
    )
    return result.key, result.image_captcha.url


def check(key, answer, request_id=None):
    return get_captcha().check(
        key=key,
        answer=answer,
        request_id=request_id,
    )


def get_captcha():
    return Captcha(
        graphite_logger=GraphiteLogger(service='captcha'),
        consumer='passport-oauth',
    )
