# -*- coding: utf-8 -*-

# Константы, определяемые в RFC 6749
BAD_FLOW = 'unauthorized_client'
BAD_CLIENT = 'invalid_client'
BAD_VERIFICATION_CODE = 'bad_verification_code'

INVALID_REQUEST = 'invalid_request'  # отсутствует параметр, присутствует несколько, т.п.
INVALID_GRANT = 'invalid_grant'  # неверный рефреш-токен, протух верификейшн код, т.п.
UNSUPPORTED_GRANT = 'unsupported_grant_type'  # grant_type не из допустимого списка
UNSUPPORTED_TOKEN = 'unsupported_token_type'  # позволяем отзывать только device-specific токены
INVALID_SCOPE = 'invalid_scope'  # несуществующий скоуп

TOKEN_TYPE = 'bearer'


AUTH_HEADER_NAME = 'Authorization'


# Наши константы
MALFORMED_AUTHORIZATION_HEADER = 'Malformed Authorization header'
BASIC_AUTH_REQUIRED = 'Basic auth required'
AUTHORIZATION_PENDING = 'authorization_pending'
PAYMENT_AUTH_PENDING = 'payment_auth_pending'

GRANT_TYPE_CODE = 'authorization_code'
GRANT_TYPE_DEVICE_CODE = 'device_code'
GRANT_TYPE_PASSWORD = 'password'
GRANT_TYPE_SESSIONID = 'sessionid'
GRANT_TYPE_XTOKEN = 'x-token'
GRANT_TYPE_ASSERTION = 'assertion'
GRANT_TYPE_FRONTEND_ASSERTION = 'frontend_assertion'
GRANT_TYPE_PASSPORT_ASSERTION = 'passport_assertion'
GRANT_TYPE_SSH_KEY = 'ssh_key'
GRANT_TYPE_CLIENT_CREDENTIALS = 'client_credentials'
GRANT_TYPE_REFRESH_TOKEN = 'refresh_token'

DROP = 'drop'
ERROR = 'error'

CAPTCHA_SOURCE_BLACKBOX = 'blackbox'
CAPTCHA_SOURCE_PROFILE = 'profile'
CAPTCHA_SOURCE_TEST = 'test'
CAPTCHA_SOURCE_RATE_LIMIT = 'rate_limit'
