# -*- coding: utf-8 -*-
import logging
import sys

from ylog.format import exception_str


def log_warning(message=None):
    """Логирует возникшее исключение как WARNING"""
    exc_info = sys.exc_info()
    message = message or exception_str(exc_info[1])
    logging.getLogger('warning').warning(message)


def log_error(request, **extra):
    """Логирует возникшее исключение как ERROR"""
    exc_info = sys.exc_info()
    logging.getLogger('exception').error(
        exception_str(exc_info[1]),
        exc_info=exc_info,
        extra=dict(
            request=request,
            **extra
        ),
    )
