# -*- coding: utf-8 -*-
from __future__ import absolute_import

import time
import uuid

import jwt


def make_jwt(secret, expires, issuer, custom_fields=None):
    payload = {
        'iat': int(time.time()),
        'jti': str(uuid.uuid1()),
        'exp': expires,
        'iss': issuer,
    }
    payload.update(custom_fields or {})
    return jwt.encode(payload, secret, algorithm='HS256')
