# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.builders.kolmogor import (
    BaseKolmogorError,
    Kolmogor,
)
from passport.backend.oauth.core.logs.graphite import GraphiteLogger


def get_kolmogor():
    return Kolmogor(
        url=settings.KOLMOGOR_URL,
        timeout=settings.KOLMOGOR_TIMEOUT,
        retries=settings.KOLMOGOR_RETRIES,
        graphite_logger=GraphiteLogger(service='kolmogor'),
        use_tvm=True,
    )


def get_kolmogor_values(space, keys):
    try:
        return get_kolmogor().get(
            space=space,
            keys=keys,
        )
    except BaseKolmogorError:
        return


def inc_kolmogor_values(space, keys):
    try:
        get_kolmogor().inc(
            space=space,
            keys=keys,
        )
    except BaseKolmogorError:
        pass
