# -*- coding: utf-8 -*-
from passport.backend.core.portallib import (
    get_ipreg,
    get_net as get_net_orig,
    InvalidIpHeaderError,
)


def clean_headers(headers):
    return dict(
        (name.replace('HTTP_', '').replace('_', '-').title(), value)
        for name, value in headers.items()
    )


def get_net(ip, headers):
    return get_net_orig(ip, headers=clean_headers(headers))


def is_yandex_ip(ip):
    """
    Функция определяет, является ли ip яндексовым и входит ли в пользовательские сети.
    """
    ip_obj = get_net(str(ip), {})
    return ip_obj['is_yandex'] and ip_obj['is_user']


__all__ = (
    'get_ipreg',
    'get_net',
    'InvalidIpHeaderError',
    'is_yandex_ip',

)
