# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.builders.tvm import TVM
from passport.backend.oauth.core.logs.graphite import GraphiteLogger


def get_tvm():
    return TVM(
        tvm_url=settings.TVM_API_URL,
        timeout=settings.TVM_API_TIMEOUT,
        retries=settings.TVM_API_RETRIES,
        graphite_logger=GraphiteLogger(service='tvm'),
        ca_cert=settings.SSL_CA_CERT,
    )
