# -*- coding: utf-8 -*-
from datetime import datetime

from passport.backend.utils.time import (
    datetime_to_integer_unixtime_nullable,
    parse_datetime,
    round_timestamp,
)


def now():
    return round_timestamp(datetime.now())


def parse_datetime_to_unixtime(dt_string):
    # совместим с форматом дат в методе oauth ЧЯ
    dt = parse_datetime(dt_string, format='%Y-%m-%d %H:%M:%S')
    return datetime_to_integer_unixtime_nullable(dt)
