# -*- coding: utf-8 -*-
from __future__ import absolute_import

from functools import wraps
import logging
import sys

from django.conf import settings
from passport.backend.oauth.core.common.error_logs import log_error
from passport.backend.utils.lock import (
    lock,
    LockError,
)
import yenv


console_logger = logging.getLogger('console')


def build_full_lock_name(lock_name, treat_rc_as_prod=True):
    env_type = yenv.type
    if yenv.type == 'rc' and treat_rc_as_prod:
        env_type = 'production'

    return '/{}/{}/{}'.format(
        yenv.name,
        env_type,
        lock_name.lstrip('/'),
    )


def run_exclusively(lock_name, treat_rc_as_prod=True):
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            try:
                with lock(
                    ylock_config=settings.YLOCK_CONFIG,
                    lock_name=build_full_lock_name(lock_name, treat_rc_as_prod=treat_rc_as_prod),
                ) as acquired:
                    if acquired:
                        return func(*args, **kwargs)
                    return
            except LockError:
                error = 'Zookeeper is unavailable'
            except Exception as e:
                error = str(e)
                log_error(request=None)

            console_logger.error('Finished with error: %s', error)
            sys.exit(1)

        return wrapper
    return decorator
