# -*- coding: utf-8 -*-
from passport.backend.oauth.core.db.config.acl import get_acl
from passport.backend.oauth.core.db.scope import list_services_with_titles


def services_to_admin(uid):
    return get_acl().admin_for_services(
        uid=uid,
        all_services=list_services_with_titles().keys(),
    )


def is_action_enabled(uid, action):
    return get_acl().is_action_enabled(uid, action)
