# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.dynamic_config import (
    BaseDynamicConfig,
    load_json,
    load_yaml,
    LoadConfigsError,
)


class BaseConfig(BaseDynamicConfig):
    def __init__(self, filename):
        super(BaseConfig, self).__init__(
            config_filenames=[filename],
            cache_time=settings.GRANTS_CONFIG_CACHE_TIME,
        )

    @property
    def data(self):
        self.load()
        return self.config


class BaseJsonConfig(BaseConfig):
    def read_config_file(self, filename):
        try:
            return load_json(filename)
        except (IOError, ValueError) as e:
            raise LoadConfigsError(e)


class BaseYamlConfig(BaseConfig):
    def read_config_file(self, filename):
        try:
            return load_yaml(filename)
        except (IOError, ValueError) as e:
            raise LoadConfigsError(e)
