# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.oauth.core.db.config.base import BaseYamlConfig


@lazy_loadable()
class ClientLists(BaseYamlConfig):
    def __init__(self):
        super(ClientLists, self).__init__(filename=settings.CLIENT_LISTS_CONFIG)

    def whitelist_for_scope(self, scope_keyword):
        return self.data['whitelist_for_scope'].get(scope_keyword, [])


def get_client_lists():
    config = LazyLoader.get_instance('ClientLists')
    config.load()
    return config
