# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.oauth.core.db.config.base import BaseJsonConfig


def normalize(string):
    return string.lower() if string else None


@lazy_loadable('DeviceNamesMapping')
class DeviceNamesMapping(BaseJsonConfig):
    def __init__(self):
        # Формат описан в https://st.yandex-team.ru/PASSP-11798
        super(DeviceNamesMapping, self).__init__(filename=settings.DEVICE_NAMES_MAPPING_CONFIG)

    def postprocess(self):
        processed = {}
        for item in self.config:
            from_, to_ = item['from'], item['to']
            key = (
                normalize(from_.get('model')),
                normalize(from_.get('manufacturer')),
            )
            processed[key] = {
                'model': to_.get('model'),
                'manufacturer': to_.get('manufacturer'),
            }
        self.config = processed


def get_device_names_mapping():
    return LazyLoader.get_instance('DeviceNamesMapping')


def get_device_name(model, manufacturer):
    data = get_device_names_mapping().data

    info_by_model_and_manufacturer = data.get((normalize(model), normalize(manufacturer)))
    info_by_model = data.get((normalize(model), None))
    info_by_manufacturer = data.get((None, normalize(manufacturer)))
    info = info_by_model_and_manufacturer or info_by_model or info_by_manufacturer or {}

    return (
        info.get('model') or
        info.get('manufacturer') or
        model or  # в ненормализованном регистре
        manufacturer  # в ненормализованном регистре
    )
