# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.oauth.core.db.config.base import BaseJsonConfig


@lazy_loadable('LoginToUidMapping')
class LoginToUidMapping(BaseJsonConfig):
    def __init__(self):
        super(LoginToUidMapping, self).__init__(filename=settings.LOGIN_TO_UID_MAPPING_CONFIG)


def get_login_to_uid_mapping():
    return LazyLoader.get_instance('LoginToUidMapping')


def get_uid_by_tagged_login_or_uid(tagged_login_or_uid):
    data = get_login_to_uid_mapping().data
    return int(data.get(tagged_login_or_uid, tagged_login_or_uid))
