# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.oauth.core.db.config.base import BaseJsonConfig
from passport.backend.oauth.core.db.config.login_to_uid_mapping import get_uid_by_tagged_login_or_uid


@lazy_loadable('Scopes')
class ScopesConfig(BaseJsonConfig):
    lazy_loadable_requirements = (
        'LoginToUidMapping',
    )

    def __init__(self):
        super(ScopesConfig, self).__init__(filename=settings.SCOPES_CONFIG)

    def postprocess(self):
        for _, data in (self.config.items()):
            visible_for_uids = data.get('visible_for_uids') or []
            visible_for = data.get('visible_for') or []
            for tagged_login in visible_for:
                uid = get_uid_by_tagged_login_or_uid(tagged_login)
                visible_for_uids.append(uid)
            data['visible_for_uids'] = list(set(visible_for_uids))


def get_scopes():
    return LazyLoader.get_instance('Scopes')
