# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.oauth.core.db.config.base import BaseYamlConfig


@lazy_loadable()
class TokenParams(BaseYamlConfig):
    def __init__(self):
        super(TokenParams, self).__init__(filename=settings.TOKEN_PARAMS_CONFIG)
        self.stateless_rules_by_client_id = {}
        self.stateless_rules_by_app_id = {}

    def postprocess(self):
        stateless_rules_by_client_id = {}
        stateless_rules_by_app_id = {}

        for rule in self.config['force_stateless'].values():
            client_id = rule.get('client_id')
            app_id = rule.get('app_id')
            if client_id:
                stateless_rules_by_client_id.setdefault(client_id, []).append(rule)
            if app_id:
                stateless_rules_by_app_id.setdefault(app_id, []).append(rule)

        self.stateless_rules_by_client_id = stateless_rules_by_client_id
        self.stateless_rules_by_app_id = stateless_rules_by_app_id


def get_token_params():
    params_config = LazyLoader.get_instance('TokenParams')
    params_config.load()
    return params_config
