# -*- coding: utf-8 -*-
from contextlib import contextmanager


@contextmanager
def UPDATE(model_instance, retries=None):
    snapshot = model_instance.snapshot()
    yield model_instance
    for transaction in model_instance.serialize(old=snapshot):
        transaction.execute(retries=retries)


@contextmanager
def CREATE(model_instance, retries=None):
    yield model_instance
    for transaction in model_instance.serialize(old=None):
        transaction.execute(retries=retries)


@contextmanager
def DELETE(model_instance, retries=None):
    yield model_instance
    for transaction in model_instance.delete():
        transaction.execute(retries=retries)
